#define WSR_PLAYER_API __declspec(dllexport)


//#include <stdio.h>
#include <stdlib.h>
//#include <string.h>
#include <Windows.h>
#include "wsr_player.h"
#include "Oswan/io.h"
#include "Oswan/ws.h"
#include "Oswan/nec/necintrf.h"
#include "Oswan/audio.h"


#define WSR_HEADER_MAGIC 0x46525357

static UINT32 _ChannelMute = 0;
static UINT8	first_song_number = 0;


//refferd to viogsf's drvimpl.cpp. thanks the author.
static struct
{
	UINT8 * ptr;
	UINT32 len;
	UINT32 fil;
	UINT32 cur;
}
buffer =
{
	0, 0, 0, 0
};

static UINT32 ReadLE16(const UINT8* pData)
{
	return (pData[0x01] << 8) | (pData[0x00] << 0);
}

static UINT32 ReadLE32(const UINT8* pData)
{
	return	(pData[0x03] << 24) | (pData[0x02] << 16) |	(pData[0x01] << 8) | (pData[0x00] << 0);
}

void Init_WSR(void)
{
	ws_audio_init();
	ws_io_init();
}

int Load_WSR(const void* pFile, unsigned Size)
{
	if (Size <= 0x20 || !pFile) return 0;
	if (ReadLE32((const UINT8*)pFile + Size - 0x20) != WSR_HEADER_MAGIC)
		return 0;

	UINT32 buflen = (4096 << 2) + 16;
	buffer.ptr = (UINT8*)malloc(buflen);
	if (!buffer.ptr)
	{
		return 0;
	}
	buffer.len = buflen;
	buffer.fil = 0;
	buffer.cur = 0;

	if (ws_init(pFile, Size) == 0)	//error
		return 0;

	first_song_number = *((const UINT8*)pFile + Size - 0x20 + 0x05);
	Init_WSR();

	return 1;
}


void Close_WSR()
{
	ws_done();
	ws_io_done();
	ws_audio_done();

	if (buffer.ptr)
	{
		free(buffer.ptr);
		buffer.ptr = 0;
	}
	buffer.len = 0;
	buffer.fil = 0;
	buffer.cur = 0;
}


int Get_FirstSong(void)
{
	return first_song_number;
}


unsigned Set_Frequency(unsigned int Freq)
{
	ws_audio_set_bps(Freq);
	return ws_audio_get_bps();
}

void Set_ChannelMuting(unsigned int Mute)
{
	_ChannelMute = Mute;
	for (unsigned i = 0; i < 4; i++)
	{
		ws_audio_set_channel_enabled(i, (Mute & (1<<i))? 0 : 1);
	}

	ws_audio_set_channel_enabled(4, (Mute & (1 << 1)) ? 0 : 1);	//voice
	ws_audio_set_channel_enabled(5, (Mute & (1 << 3)) ? 0 : 1);	//noise
	ws_audio_set_channel_enabled(6, (Mute & (1 << 2)) ? 0 : 1);	//sweep
	ws_audio_set_channel_enabled(7, (Mute & (1 << 1)) ? 0 : 1);	//hyper voice

	return;
}

unsigned int Get_ChannelMuting(void)
{
	return _ChannelMute;
}



void Reset_WSR(unsigned SongNo)
{
	ws_reset();
	ws_io_reset();
	ws_audio_reset();
	nec_reset(NULL);
	nec_set_reg(NEC_SP, 0x2000);
	nec_set_reg(NEC_AW, SongNo);
	ws_audio_play();
	buffer.cur = 0;
	buffer.fil = 0;
}


void FlushBuffer_WSR(const short * finalWave, unsigned long length)
{
	if (length > buffer.len - buffer.fil)
	{
		length = buffer.len - buffer.fil;
	}
	if (length > 0)
	{
		memcpy(buffer.ptr + buffer.fil, finalWave, length);
		buffer.fil += length;
	}
}

//refferd to viogsf's drvimpl.cpp. thanks the author.
int Update_WSR(void* pBuf, unsigned Buflen, unsigned Samples)
{
	int ret = 0;
	UINT32 bytes = Samples << 2;
	UINT8* des = (UINT8*)pBuf;

	if (buffer.ptr == 0 || pBuf == 0)
		return 0;

	while (bytes > 0)
	{
		UINT32 remain = buffer.fil - buffer.cur;
		while (remain == 0)
		{
			buffer.cur = 0;
			buffer.fil = 0;

			WsExecuteLine(NULL, FALSE);
				
			remain = buffer.fil - buffer.cur;
		}
		UINT32 len = remain;
		if (len > bytes)
		{
			len = bytes;
		}
		memcpy(des, buffer.ptr + buffer.cur, len);
		bytes -= len;
		des += len;
		buffer.cur += len;
		ret += len;
	}
	return ret;

}


static WSRPlayerApi g_wsr_player_api =
{
	Load_WSR, 
	Get_FirstSong, 
	Set_Frequency, 
	Set_ChannelMuting, 
	Get_ChannelMuting, 
	Reset_WSR, 
	Close_WSR, 
	Update_WSR
};

WSRPlayerApi* WSRPlayerSetUp(void)
{
	return &g_wsr_player_api;
}