#include "stdafx.h"
#include "external_vars.h"

const unsigned wsr_channel_count = 4;

const unsigned sample_rate_count = 13;
const char * const sample_rate_name[sample_rate_count] = { "11025", "12000", "16000", "22050", "24000", "32000", "44100", "48000", "64000", "88200", "96000", "176400", "192000" };
const unsigned sample_rate_value[sample_rate_count] = { 11025, 12000, 16000, 22050, 24000, 32000, 44100, 48000, 64000, 88200, 96000, 176400, 192000 };

const unsigned emulation_core_count = 3;
const char * const emulation_core_name[emulation_core_count] = { "mednafen", "oswan", "in_wsr" };
const char *emulation_core_drive_name[emulation_core_count] = { "wsr_player_mednafen.dll", "wsr_player_oswan.dll", "wsr_player_in_wsr.dll" };

const GUID guid_prefs_wsr = { 0xee3ca0a7, 0x4ccb, 0x45a8,{ 0xa1, 0x6c, 0x13, 0x99, 0x86, 0xe1, 0x2f, 0xfe } };
static const GUID guid_cfg_default_song_len = { 0x26fabddf, 0xc573, 0x4533,{ 0xbb, 0x57, 0x73, 0x10, 0x23, 0x6c, 0xfc, 0x37 } };
static const GUID guid_cfg_default_fade_len = { 0xc8997055, 0xb10, 0x47d0,{ 0x92, 0xbc, 0x8d, 0x7c, 0x1b, 0x98, 0x3b, 0x57 } };
static const GUID guid_cfg_default_loop_count = { 0xae2556f5, 0x2661, 0x4960,{ 0xa7, 0xbc, 0x77, 0x78, 0x3b, 0x8, 0x35, 0x47 } };
static const GUID guid_cfg_ignore_playlist = { 0xaaee074c, 0x8b5e, 0x4a61,{ 0x8f, 0x49, 0xe3, 0xc9, 0xe0, 0xcc, 0x18, 0x26 } };
static const GUID guid_cfg_default_subsong_max = { 0x5a365060, 0xbb1c, 0x4475,{ 0xba, 0x56, 0x95, 0xa7, 0x38, 0x3d, 0x16, 0xc5 } };
static const GUID guid_cfg_play_infinitely = { 0xde58ae46, 0xe0a8, 0x4569,{ 0x83, 0xc2, 0xaf, 0x97, 0xbf, 0x6b, 0xff, 0xfc } };
static const GUID guid_cfg_detect_silence = { 0x66291599, 0xe0f3, 0x4cfa,{ 0xb9, 0x88, 0x39, 0x99, 0x2, 0xa, 0xf2, 0xf7 } };
static const GUID guid_cfg_silence_len = { 0xcf18daea, 0xea20, 0x42ad,{ 0x96, 0xb3, 0x3d, 0xe9, 0x5c, 0xe9, 0x54, 0x4d } };
static const GUID guid_cfg_display_track_num = { 0x731ef198, 0xdcbf, 0x4100,{ 0xb0, 0x4d, 0x85, 0x0, 0x22, 0x96, 0xb1, 0x68 } };
static const GUID guid_cfg_channel_muting = { 0x9168d736, 0x2fa4, 0x4127,{ 0xb1, 0x55, 0xeb, 0x1, 0xae, 0xbe, 0x1a, 0xed } };
static const GUID guid_cfg_sample_rate = { 0xba216191, 0x832f, 0x4a10,{ 0xad, 0x4c, 0x4e, 0x50, 0xe5, 0x7b, 0x95, 0x1c } };
static const GUID guid_cfg_emulation_core = { 0xf835c8d1, 0x3448, 0x4103,{ 0x89, 0x45, 0x33, 0xbd, 0x4d, 0xd2, 0xd6, 0x37 } };
static const GUID guid_cfg_volume[emulation_core_count] =
{
	{ 0x152a7235, 0xf6ce, 0x4ccf,{ 0xb6, 0x43, 0x74, 0x80, 0x95, 0xc1, 0x4d, 0x40 } },
	{ 0x9fd85abd, 0xdc9a, 0x4553,{ 0xba, 0xe1, 0x42, 0xf9, 0x51, 0x58, 0x1f, 0x59 } },
	{ 0x84f2090f, 0xb8ca, 0x4e51,{ 0xa4, 0x79, 0xc0, 0xdc, 0xe7, 0x9b, 0x23, 0x4c } }
};


cfg_int cfg_default_song_len(guid_cfg_default_song_len, 300000);
cfg_int cfg_default_fade_len(guid_cfg_default_fade_len, 5000);
cfg_int cfg_default_loop_count(guid_cfg_default_loop_count, 2);
cfg_int cfg_detect_silence(guid_cfg_detect_silence, 1);
cfg_int cfg_silence_len(guid_cfg_silence_len, 5);
cfg_int cfg_ignore_playlist(guid_cfg_ignore_playlist, false);
cfg_int cfg_default_subsong_max(guid_cfg_default_subsong_max, 255);
cfg_int cfg_play_infinitely(guid_cfg_play_infinitely, 0);
cfg_int cfg_display_track_num(guid_cfg_display_track_num, 0);
cfg_uint_atomic cfg_channel_muting(guid_cfg_channel_muting, 0, std::memory_order_relaxed);
cfg_int cfg_sample_rate(guid_cfg_sample_rate, 48000);
cfg_int cfg_emulation_core(guid_cfg_emulation_core, 0);


cfg_int cfg_volume_0(guid_cfg_volume[0], 100);
cfg_int cfg_volume_1(guid_cfg_volume[1], 100);
cfg_int cfg_volume_2(guid_cfg_volume[2], 100);

cfg_int *cfg_volume[emulation_core_count] = {&cfg_volume_0, &cfg_volume_1, &cfg_volume_2};
