#include "stdafx.h"
#include "resource.h"
#include "foo_input_wsr.h"
#include "external_vars.h"


class preferences_page_instace_wsr : public preferences_page_instance
{
	HWND m_parent;
	HWND m_hwnd;
	preferences_page_callback::ptr m_callback;
public:
	static BOOL CALLBACK ConfigProc(HWND wnd, UINT msg, WPARAM wp, LPARAM lp)
	{
		switch (msg)
		{
		case WM_INITDIALOG:
		{
							  uSetWindowLong(wnd, DWL_USER, lp);				

							  CheckDlgButton(wnd, IDC_PLAY_INFINITELY, (UINT)cfg_play_infinitely);
							  uSetDlgItemInt(wnd, IDC_DEFAULT_SONG_LEN, cfg_default_song_len, FALSE);
							  uSetDlgItemInt(wnd, IDC_DEFAULT_FADE_LEN, cfg_default_fade_len, FALSE);

							  uSendDlgItemMessage(wnd, IDC_SPIN_DEFAULT_LOOP_COUNT, UDM_SETRANGE32, (WPARAM)0, (LPARAM)50);
							  uSendDlgItemMessage(wnd, IDC_SPIN_DEFAULT_LOOP_COUNT, UDM_SETPOS, 0, (LPARAM)MAKELONG(cfg_default_loop_count, 0));			

							  CheckDlgButton(wnd, IDC_DETECT_SILENCE, (UINT)cfg_detect_silence);
							  uSendDlgItemMessage(wnd, IDC_SPIN_SILENCE_LEN, UDM_SETRANGE32, (WPARAM)1, (LPARAM)3600);
							  uSendDlgItemMessage(wnd, IDC_SPIN_SILENCE_LEN, UDM_SETPOS, 0, (LPARAM)MAKELONG(cfg_silence_len, 0));

							  CheckDlgButton(wnd, IDC_DISPLAY_TRACK_NUM, (UINT)cfg_display_track_num);
							  uSetDlgItemInt(wnd, IDC_VOLUME, cfg_volume[cfg_emulation_core]->get_value(), FALSE);
							  CheckDlgButton(wnd, IDC_IGNORE_PLAYLIST, (UINT)cfg_ignore_playlist);

							  uSendDlgItemMessage(wnd, IDC_SPIN_DEFAULT_SUBSONG_MAX, UDM_SETRANGE32, (WPARAM)0, (LPARAM)255);
							  uSendDlgItemMessage(wnd, IDC_SPIN_DEFAULT_SUBSONG_MAX, UDM_SETPOS, 0, (LPARAM)MAKELONG(cfg_default_subsong_max, 0));

							  //combo box
							  HWND h = uGetDlgItem(wnd, IDC_SAMPLE_RATE);
							  unsigned cur_sel = 0;
							  for (unsigned i = 0; i < sample_rate_count; i++)
							  {
								  uSendMessageText(h, CB_ADDSTRING, 0, sample_rate_name[i]);
								  if (cfg_sample_rate == sample_rate_value[i])
									  cur_sel = i;
							  }
							  uSendMessage(h, CB_SETCURSEL, cur_sel, 0);

							  h = uGetDlgItem(wnd, IDC_EMULATION_CORE);
							  for (unsigned i = 0; i < emulation_core_count; i++)
							  {
								  uSendMessageText(h, CB_ADDSTRING, 0, emulation_core_name[i]);					  
							  }					  
							  uSendMessage(h, CB_SETCURSEL, cfg_emulation_core, 0);

							  for (unsigned i = 0; i < wsr_channel_count; i++)
							  {
								  CheckDlgButton(wnd, IDC_MUTING1 + i, (cfg_channel_muting.load() & (1<<i)));
							  }
							 
							  break;
		}
		case WM_COMMAND:
		{
			//Channel Muting. I will update them immediately.
			if (LOWORD(wp) >= IDC_MUTING1 && LOWORD(wp) < IDC_MUTING1 + wsr_channel_count)
			{
				unsigned cur_channel = LOWORD(wp) - IDC_MUTING1;
				UINT checked = IsDlgButtonChecked(wnd, LOWORD(wp));

				cfg_channel_muting.fetch_and(~(1 << cur_channel));
				cfg_channel_muting.fetch_or(checked << cur_channel);

				break;
			}
						   preferences_page_instace_wsr* p_this;
						   p_this = reinterpret_cast<preferences_page_instace_wsr*> (uGetWindowLong(wnd, DWL_USER));
						   switch (LOWORD(wp))
						   {
						   case IDC_DETECT_SILENCE: case IDC_DEFAULT_FADE_LEN: case IDC_PLAY_INFINITELY:
						   case IDC_IGNORE_PLAYLIST: case IDC_DEFAULT_LOOP_COUNT: case IDC_SILENCE_LEN: case IDC_DEFAULT_SONG_LEN:
						   case IDC_SPIN_DEFAULT_LOOP_COUNT: case IDC_SPIN_DEFAULT_SUBSONG_MAX: case IDC_DEFAULT_SUBSONG_MAX: case IDC_VOLUME:
						   case IDC_DISPLAY_TRACK_NUM: case IDC_SPIN_SILENCE_LEN: case IDC_SAMPLE_RATE:
							   if (p_this) p_this->m_callback->on_state_changed();
							   break;
						   case IDC_EMULATION_CORE:
						   {
							   if (HIWORD(wp) == CBN_SELCHANGE)
							   {
								   int cur_sel = uSendDlgItemMessage(wnd, IDC_EMULATION_CORE, CB_GETCURSEL, 0, 0);
								   uSetDlgItemInt(wnd, IDC_VOLUME, static_cast<UINT>(cfg_volume[cur_sel]->get_value()), FALSE);
								   if (p_this) p_this->m_callback->on_state_changed();
							   }
							   break;
						   }
						   default:
							   break;
						   }
						   break;
		}			
		case WM_DESTROY:
		{
						   uSetWindowLong(wnd, DWL_USER, 0);
						   break;
		}
		default:
			return FALSE;
		}
		return TRUE;
	}


//Constructeor
	preferences_page_instace_wsr(HWND parent, preferences_page_callback::ptr callback) : 
		m_parent(parent), 
		m_callback(callback)
	{
		m_hwnd = create(m_parent);
	}

	HWND get_wnd()
	{
		return m_hwnd;
	}

	HWND create(HWND p_parent)
	{
		return uCreateDialog(IDD_DIALOG1, p_parent, ConfigProc, reinterpret_cast<LPARAM>(this));
	}

	t_uint32 get_state()
	{
		unsigned cur_sample_rate_sel = uSendDlgItemMessage(m_hwnd, IDC_SAMPLE_RATE, CB_GETCURSEL, 0, 0);

		if (cfg_play_infinitely != IsDlgButtonChecked(m_hwnd, IDC_PLAY_INFINITELY) ||
			cfg_default_song_len != uGetDlgItemInt(m_hwnd, IDC_DEFAULT_SONG_LEN, NULL, FALSE) ||
			cfg_default_fade_len != uGetDlgItemInt(m_hwnd, IDC_DEFAULT_FADE_LEN, NULL, FALSE) ||
			cfg_default_loop_count != uSendDlgItemMessage(m_hwnd, IDC_SPIN_DEFAULT_LOOP_COUNT, UDM_GETPOS, 0, 0) ||
			cfg_detect_silence != IsDlgButtonChecked(m_hwnd, IDC_DETECT_SILENCE) ||
			cfg_silence_len != uSendDlgItemMessage(m_hwnd, IDC_SPIN_SILENCE_LEN, UDM_GETPOS, 0, 0) ||
			cfg_display_track_num != IsDlgButtonChecked(m_hwnd, IDC_DISPLAY_TRACK_NUM) ||
			cfg_volume[cfg_emulation_core]->get_value() != uGetDlgItemInt(m_hwnd, IDC_VOLUME, NULL, FALSE) ||
			cfg_ignore_playlist != IsDlgButtonChecked(m_hwnd, IDC_IGNORE_PLAYLIST) ||
			cfg_default_subsong_max != uSendDlgItemMessage(m_hwnd, IDC_SPIN_DEFAULT_SUBSONG_MAX, UDM_GETPOS, 0, 0) ||
			cfg_sample_rate != sample_rate_value[cur_sample_rate_sel] ||
			cfg_emulation_core != uSendDlgItemMessage(m_hwnd, IDC_EMULATION_CORE, CB_GETCURSEL, 0, 0)
			)
			return preferences_state::changed | preferences_state::resettable;
		return preferences_state::resettable;
	}

	void apply()
	{
		cfg_play_infinitely = IsDlgButtonChecked(m_hwnd, IDC_PLAY_INFINITELY);
		cfg_default_song_len = uGetDlgItemInt(m_hwnd, IDC_DEFAULT_SONG_LEN, NULL, FALSE);
		cfg_default_fade_len = uGetDlgItemInt(m_hwnd, IDC_DEFAULT_FADE_LEN, NULL, FALSE);
		cfg_default_loop_count = uSendDlgItemMessage(m_hwnd, IDC_SPIN_DEFAULT_LOOP_COUNT, UDM_GETPOS, 0, 0);
		cfg_detect_silence = IsDlgButtonChecked(m_hwnd, IDC_DETECT_SILENCE);
		cfg_silence_len = uSendDlgItemMessage(m_hwnd, IDC_SPIN_SILENCE_LEN, UDM_GETPOS, 0, 0);
		cfg_display_track_num = IsDlgButtonChecked(m_hwnd, IDC_DISPLAY_TRACK_NUM);

		cfg_ignore_playlist = IsDlgButtonChecked(m_hwnd, IDC_IGNORE_PLAYLIST);
		cfg_default_subsong_max = uSendDlgItemMessage(m_hwnd, IDC_SPIN_DEFAULT_SUBSONG_MAX, UDM_GETPOS, 0, 0);

		unsigned cur_sel = uSendDlgItemMessage(m_hwnd, IDC_SAMPLE_RATE, CB_GETCURSEL, 0, 0);
		cfg_sample_rate = sample_rate_value[cur_sel];
		cfg_emulation_core = uSendDlgItemMessage(m_hwnd, IDC_EMULATION_CORE, CB_GETCURSEL, 0, 0);
		*(cfg_volume[cfg_emulation_core]) = uGetDlgItemInt(m_hwnd, IDC_VOLUME, NULL, FALSE);
		if (cfg_volume[cfg_emulation_core]->get_value() > 500) *(cfg_volume[cfg_emulation_core]) = 500;
		if (cfg_volume[cfg_emulation_core]->get_value() <= 0) *(cfg_volume[cfg_emulation_core]) = 100;
		uSetDlgItemInt(m_hwnd, IDC_VOLUME, cfg_volume[cfg_emulation_core]->get_value(), FALSE);

		m_callback->on_state_changed();
	}

	// Resets this page's content to the default values.
	// Does not apply any changes -
	// lets user preview the changes before hitting "apply".
	void reset()
	{
		CheckDlgButton(m_hwnd, IDC_PLAY_INFINITELY, BST_UNCHECKED);
		uSetDlgItemInt(m_hwnd, IDC_DEFAULT_SONG_LEN, 300000, FALSE);
		uSetDlgItemInt(m_hwnd, IDC_DEFAULT_FADE_LEN, 5000, FALSE);
		uSendDlgItemMessage(m_hwnd, IDC_SPIN_DEFAULT_LOOP_COUNT, UDM_SETPOS, 0, (LPARAM)MAKELONG(2, 0));
		CheckDlgButton(m_hwnd, IDC_DETECT_SILENCE, BST_CHECKED);
		uSendDlgItemMessage(m_hwnd, IDC_SPIN_SILENCE_LEN, UDM_SETPOS, 0, (LPARAM)MAKELONG(5, 0));
		CheckDlgButton(m_hwnd, IDC_DISPLAY_TRACK_NUM, BST_UNCHECKED);
		uSetDlgItemInt(m_hwnd, IDC_VOLUME, 100, FALSE);
		CheckDlgButton(m_hwnd, IDC_IGNORE_PLAYLIST, BST_UNCHECKED);
		uSendDlgItemMessage(m_hwnd, IDC_SPIN_DEFAULT_SUBSONG_MAX, UDM_SETPOS, 0, (LPARAM)MAKELONG(255, 0));

		uSendDlgItemMessage(m_hwnd, IDC_SAMPLE_RATE, CB_SETCURSEL, 7, 0);
		uSendDlgItemMessage(m_hwnd, IDC_EMULATION_CORE, CB_SETCURSEL, 0, 0);

		for (unsigned i = 0; i < wsr_channel_count; i++)
		{
			CheckDlgButton(m_hwnd, IDC_MUTING1 + i, BST_UNCHECKED);
		}
		cfg_channel_muting.store(0);

		m_callback->on_state_changed();
	}

};

class preferences_foo_input_wsr : public preferences_page_v3
{
public:

	virtual const char * get_name()
	{
		return input_wsr::g_get_name();
	}

	virtual GUID get_guid()
	{
		return guid_prefs_wsr;
	}

	virtual GUID get_parent_guid()
	{
		return guid_input;
	}

	virtual preferences_page_instance::ptr instantiate(HWND parent, preferences_page_callback::ptr callback)
	{
		return new service_impl_t< preferences_page_instace_wsr>(parent, callback);
	}

};

static preferences_page_factory_t<preferences_foo_input_wsr> g_preferences_foo_input_wsr;
