#ifndef INC_CFG_INT_T_ATOMIC_H
#define INC_CFG_INT_T_ATOMIC_H

#include <atomic>

template<typename t_inttype>
class cfg_int_t_atomic : public cfg_var {
private:
	std::atomic<t_inttype> m_val;
	std::memory_order m_memory_order;
protected:
	void get_data_raw(stream_writer * p_stream, abort_callback & p_abort){p_stream->write_lendian_t(m_val.load(m_memory_order), p_abort);}
	void set_data_raw(stream_reader * p_stream, t_size p_sizehint, abort_callback & p_abort){
		t_inttype temp;
		p_stream->read_lendian_t(temp, p_abort);
		m_val.store(temp, m_memory_order);
	}

public:
	explicit inline cfg_int_t_atomic(const GUID & p_guid, t_inttype p_default, std::memory_order p_memory_order = std::memory_order_relaxed) : cfg_var(p_guid), m_memory_order(p_memory_order) { m_val.store(p_default, m_memory_order); }
	inline operator t_inttype() const { return m_val.load(m_memory_order); }
	inline t_inttype get_value() const { return m_val.load(m_memory_order); }
	
	inline void store(t_inttype p_val){ m_val.store(p_val, m_memory_order); }
	inline t_inttype load() const { return m_val.load(m_memory_order);}
	inline t_inttype fetch_and(t_inttype p_val) { return m_val.fetch_and(p_val, m_memory_order); }
	inline t_inttype fetch_or(t_inttype p_val) { return m_val.fetch_or(p_val, m_memory_order); }

};


typedef cfg_int_t_atomic<t_int32> cfg_int_atomic;
typedef cfg_int_t_atomic<t_uint32> cfg_uint_atomic;


#endif