/*
 * SYSTEM 16 ARCADE EMULATOR SOURCE CODE
 * 
 * Copyright 1996/97 Thierry Lescot
 */

#include "shinobi.h"
#include <allegro.h>

extern unsigned long total_palette, total_new_colors, total_palette_reset;
unsigned char reset_palette=0, ws[80];
extern unsigned char pal_bank;

unsigned char Palette256[0x10000];
unsigned int *PaletteShinobi;
unsigned long NewColorsTab[256];
unsigned char FastPalette[32];

void *base_palette256, *base_palette_shinobi, *base_new_colors_tab;
void *base_fast_palette;

unsigned char pal_counter=1, number_of_new_colors;

extern unsigned char *RAM[0x100];

void Update_Palette() {
   int i;
   RGB pal;
   /*
   sprintf(ws, "palette: %d", number_of_new_colors);
   message_emul(0, 2, ws);
    */
   while ((inportb(0x3DA)&0x08)!=0);
   while ((inportb(0x3DA)&0x08)==0);
   #ifndef NO_PALETTE
   for (i=0;i!=number_of_new_colors;i++) {
      pal.r=(NewColorsTab[i]&0x00000F00)>>6;
      pal.g=(NewColorsTab[i]&0x0000F000)>>10;
      pal.b=(NewColorsTab[i]&0x000F0000)>>14;
      _set_color((NewColorsTab[i]&0x000000FF), (RGB *)&pal);
   }
   #endif
   total_palette++;
   total_new_colors+=number_of_new_colors;
   if (reset_palette) {
      reset_palette=0;
      for (i=0;i!=0x10000;i++) Palette256[i]=0;
      total_palette_reset++;
   }
}

void Create_Palette() {
   int r, g, b, vr, vrs, i, old_vr;
   RGB pal;
   
   base_palette256=&Palette256[0];
   base_palette_shinobi=RAM[pal_bank];
   base_new_colors_tab=&NewColorsTab[0];
   base_fast_palette=&FastPalette[0];
   PaletteShinobi=(unsigned int *)&RAM[pal_bank][0];
   
   for (i=0;i!=0x10000;i++) Palette256[i]=0;
   
   pal.r=pal.g=pal.b=0;
   set_color(0, (RGB *)&pal);
   
}
