/*
 * SYSTEM 16 ARCADE EMULATOR SOURCE CODE
 * 
 * Copyright 1996/97 Thierry Lescot
 */

#include <allegro.h>
#include "cpudefs.h"

extern char game_basename[9];
extern char game;

extern UBYTE shinobi_ds1[10], shinobi_ds2[10], reset_palette;

void Setup_Dip_Swicths() {
   UBYTE sw1=shinobi_ds1[game], sw2=shinobi_ds2[game];
   int old_select=1, select=0, change=1;
   int touche=0, max_opt=(game)? 6:4;
   Hide_Screen("OPTION SWITCH SETTINGS");
   if ((game==1)||(game==4)) {
      OutlineXY_Text(91, 50, 5, "LANGUAGE");
      OutlineXY_Text(59 ,65 , 5, "BULLET SPEED");
      OutlineXY_Text(75 ,80 , 5, "DIFFICULTY");
      OutlineXY_Text(35 ,95 , 5, "NUMBER OF LIVES");
      OutlineXY_Text(11 ,110, 5, "ATTRACT MODE SOUND");
      OutlineXY_Text(83 ,125, 5, "GAME TYPE");
      OutlineXY_Text(67 ,140, 5, "COIN SWITCH");
   } else {
      OutlineXY_Text(75, 50, 5, "DIFFICULTY");
      OutlineXY_Text(59 ,65 , 5, "PLAYER METER");
      OutlineXY_Text(35 ,80 , 5, "NUMBER OF LIVES");
      OutlineXY_Text(11 ,95, 5, "ATTRACT MODE SOUND");
      OutlineXY_Text(67 ,110, 5, "COIN SWITCH");
   }
   Outline_Text(190, 2, "UP/DOWN to select");
   Outline_Text(205, 2, "SPACE BAR to change");
   Outline_Text(220, 2, "ESC when finished");
   Show_Screen();
   do {
      if (old_select!=select) {
	 rect(screen, 5, 47+(old_select*15), 314, 60+(old_select*15), 0);
	 rect(screen, 5, 47+(select*15), 314, 60+(select*15), 4);
      }
      if ((change)&&((game==1)||(game==4))) {
	 change=0;
	 rectfill(screen, 160, 49, 310, 59, 0);
	 if (sw2&0x80) OutlineXY_Text(165, 50, 1, "ENGLISH");
	 else OutlineXY_Text(165, 50, 1, "JAPANESE");
	 rectfill(screen, 160, 64, 310, 74, 0);
	 if (sw2&0x40) OutlineXY_Text(165, 65, 1, "FAST");
	 else OutlineXY_Text(165, 65, 1, "SLOW");
	 rectfill(screen, 160, 79, 310, 89, 0);
	 switch (sw2&0x30) {
	  case 0x00: OutlineXY_Text(165, 80, 1, "NORMAL"); break;
	  case 0x10: OutlineXY_Text(165, 80, 1, "EASY"); break;
	  case 0x20: OutlineXY_Text(165, 80, 1, "HARD"); break;
	  case 0x30: OutlineXY_Text(165, 80, 1, "HARDEST"); break;
	 }
	 rectfill(screen, 160, 94, 310, 104, 0);
	 switch (sw2&0x0C) {
	  case 0x00: OutlineXY_Text(165, 95, 1, "3"); break;
	  case 0x04: OutlineXY_Text(165, 95, 1, "2"); break;
	  case 0x08: OutlineXY_Text(165, 95, 1, "5"); break;
	  case 0x0C: OutlineXY_Text(165, 95, 1, "UNLIMITED"); break;
	 }
	 rectfill(screen, 160, 109, 310, 119, 0);
	 if (sw2&0x02) OutlineXY_Text(165, 110, 1, "ON");
	 else OutlineXY_Text(165, 110, 1, "OFF");
	 rectfill(screen, 160, 124, 310, 134, 0);
	 if (sw2&0x01) OutlineXY_Text(165, 125, 1, "UPRIGHT");
	 else OutlineXY_Text(165, 125, 1, "COCKTAIL TABLE");
	 rectfill(screen, 160, 139, 310, 149, 0);
	 if (sw1) OutlineXY_Text(165, 140, 1, "FREEPLAY");
	 else OutlineXY_Text(165, 140, 1, "INSERT COIN");
      }
      if ((change)&&(game==2)) { /* ALTERED BEAST */
	 change=0;
	 rectfill(screen, 160, 49, 310, 59, 0);
	 switch (sw2&0xC0) {
	  case 0x40: OutlineXY_Text(165, 50, 1, "EASY"); break;
	  case 0x00: OutlineXY_Text(165, 50, 1, "NORMAL"); break;
	  case 0x80: OutlineXY_Text(165, 50, 1, "HARD"); break;
	  case 0xC0: OutlineXY_Text(165, 50, 1, "HARDEST"); break;
	 }
	 rectfill(screen, 160, 64, 310, 74, 0);
	 switch (sw2&0x30) {
	  case 0x00: OutlineXY_Text(165, 65, 1, "OOO"); break;
	  case 0x10: OutlineXY_Text(165, 65, 1, "OO"); break;
	  case 0x20: OutlineXY_Text(165, 65, 1, "OOOO"); break;
	  case 0x30: OutlineXY_Text(165, 65, 1, "OOOOO"); break;
	 }
	 rectfill(screen, 160, 79, 310, 89, 0);
	 switch (sw2&0x0C) {
	  case 0x00: OutlineXY_Text(165, 80, 1, "3"); break;
	  case 0x04: OutlineXY_Text(165, 80, 1, "2"); break;
	  case 0x08: OutlineXY_Text(165, 80, 1, "4"); break;
	  case 0x0C: OutlineXY_Text(165, 80, 1, "240"); break;
	 }
	 rectfill(screen, 160, 94, 310, 104, 0);
	 if (sw2&0x02) OutlineXY_Text(165, 95, 1, "ON");
	 else OutlineXY_Text(165, 95, 1, "OFF");
	 rectfill(screen, 160, 109, 310, 119, 0);
	 if (sw1) OutlineXY_Text(165, 110, 1, "FREEPLAY");
	 else OutlineXY_Text(165, 110, 1, "INSERT COIN");
      }
      old_select=select;
      while (key[touche]);
      clear_keybuf();
      touche=(readkey()>>8);
      switch (touche) {
       case KEY_UP:
	 if (select!=0) select--;
	 else select=max_opt;
	 break;
       case KEY_DOWN:
	 if (select!=max_opt) select++;
	 else select=0;
	 break;
       case KEY_SPACE: 
	   {
	      change=1;
	      if ((game==1)||(game==4)) {
		 switch (select) {
		  case 0: sw2=((sw2&0x7F)|((~(sw2&0x80))&0x80)); break;
		  case 1: sw2=((sw2&0xBF)|((~(sw2&0x40))&0x40)); break;
		  case 2: sw2=((sw2&0xCF)|(((sw2&0x30)+0x10)&0x30)); break;
		  case 3: sw2=((sw2&0xF3)|(((sw2&0x0C)+0x04)&0x0C)); break;
		  case 4: sw2=((sw2&0xFD)|((~(sw2&0x02))&0x02)); break;
		  case 5: sw2=((sw2&0xFE)|((~(sw2&0x01))&0x01)); break;
		  case 6: sw1=~sw1; break;
		 }
	      } else {
		 switch (select) {
		  case 0: sw2=((sw2&0x3F)|(((sw2&0xC0)+0x40)&0xC0)); break;
		  case 1: sw2=((sw2&0xCF)|(((sw2&0x30)+0x10)&0x30)); break;
		  case 2: sw2=((sw2&0xF3)|(((sw2&0x0C)+0x04)&0x0C)); break;
		  case 3: sw2^=0x02; break;
		  case 4: sw1=~sw1; break;
		 }
	      }
	   }
	 break;
      }
   } while (touche!=KEY_ESC);
   while (key[KEY_ESC]);
   clear_keybuf();
   shinobi_ds1[game]=sw1;
   shinobi_ds2[game]=sw2;
}
